import java.util.Arrays;
import java.util.LinkedList;
import java.util.Scanner;


public class Main {

	static boolean[] used = new boolean[20000];
	static long[] curweight = new long[20000];
	static LinkedList[] ways = new LinkedList[20000];
	static Backtrack[] from_a = new Backtrack[20000];
	
	static class Road_to {
		public int path;
		public long weight;
		public long index;
		public Road_to(int path, long weight, long index) {
			this.path = path;
			this.weight = weight;
			this.index = index;
		}
	}
	
	static class Backtrack {
		public int from;
		public long index;
		public Backtrack(int from, long index) {
			this.from = from;
			this.index = index;
		}
	}
	
	static int n;
	static long m;
	
	static void find(int from, long excl) {
		for (Object v : ways[from]) {
			if (((Road_to)v).index == excl) continue;
			int i = ((Road_to)v).path;
			if (curweight[from] + ((Road_to)v).weight < curweight[i]) {
				curweight[i] =curweight[from] + ((Road_to)v).weight;
				if (excl == -1) from_a[i] = new Backtrack(from, ((Road_to)v).index);
			}
		}
		used[from] = true;
		long min = Long.MAX_VALUE / 2;
		int minindex = -1;
		for (int i=0; i<n; ++i) {
			if (!used[i] && curweight[i] < min) {
				min = curweight[i];
				minindex = i;
			}
		}
		if (minindex != -1) find(minindex, excl);
	}
	
	public static void main(String[] args) {
		Scanner in = new Scanner(System.in);
		
		for (int i=0;i<20000;++i) ways[i] = new LinkedList();
		n = in.nextInt();
		m = in.nextInt();
		for (int i=0;i<m;++i) {
			int from = in.nextInt();
			int to = in.nextInt();
			ways[from-1].add(new Road_to(to-1, in.nextInt(), i));
			ways[to-1].add(new Road_to(from-1, in.nextInt(), i));
		}
		Arrays.fill(used, false);
		Arrays.fill(curweight, Long.MAX_VALUE / 2);
		curweight[0]=0;
		find(0, -1);
		long minw = curweight[n-1];
		if (minw == Long.MAX_VALUE / 2){
			System.out.println(0);
			return;
		}
		LinkedList exclroads = new LinkedList();
		int ix = n-1;
		while (ix != 0) {
			exclroads.add(Long.valueOf(from_a[ix].index));
			ix = from_a[ix].from;
		}
		
		LinkedList important = new LinkedList();
		for (Object obj : exclroads) {
			long i = ((Long)obj).longValue();
			Arrays.fill(used, false);
			Arrays.fill(curweight, Long.MAX_VALUE / 2);
			curweight[0]=0;
			find(0, i);
			if (curweight[n-1] > minw) important.add(Long.valueOf(i+1));
		}
		
		System.out.println(important.size());
		for (Object i : important) {
			System.out.print(i);
			System.out.print(" ");
		}
		System.out.println();
	}

}
